VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameW" (ByVal lpFileName As Long, ByVal nBufferLength As Long, ByVal lpBuffer As Long, ByVal lpFilePart As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Function GetFullPath(ByVal Path As String) As String
   Dim sLen As Long
   GetFullPath = Space(512)
   sLen = GetFullPathName(StrPtr(Path), 511, StrPtr(GetFullPath), 0)
   GetFullPath = Left(GetFullPath, sLen)
End Function

Public Function ConvertFile(ByVal InFile As String, ByVal OutFile As String) As Boolean
   Dim retval As Long, convFlags As Long

   ConvertFile = False

   Call pdf.CreateNewPDF(vbNullString)                         ' The output file will be created later
   Call pdf.SetDocInfo(TDocumentInfo.diProducer, vbNullString) ' No need to override the original producer

   ' The flag ifImportAsPage makes sure that pages will not be converted to templates.
   ' We don't import a piece info dictionary here since this dictionary contains private data that
   ' is only usable in the application that created the data. InDesign, for example, stores original
   ' images and document files in this dictionary, if external resources were placed on a page.
   Call pdf.SetImportFlags((TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage) And Not TImportFlags.ifPieceInfo)
   ' The flag if2UseProxy reduces the memory usage. The duplicate check is optional but recommended.
   ' The resource name check can be omitted when we optimize a PDF file.
   Call pdf.SetImportFlags2(TImportFlags2.if2UseProxy Or TImportFlags2.if2DuplicateCheck Or TImportFlags2.if2NoResNameCheck)

   retval = pdf.OpenImportFile(InFile, TPwdType.ptOpen, vbNullString)
   If retval < 0 Then
      If pdf.IsWrongPwd(retval) Then
         Call MsgBox("PDFError File is encrypted!")
      End If
      Call pdf.FreePDF
      Exit Function
   End If
   Call pdf.ImportPDFFile(1, 1#, 1#)
   Call pdf.CloseImportFile

   ' It is not allowed to call this function twice for the same document in memory!
   ' In addition, we can either optimize the entire PDF file or nothing.
   '
   ' -----------------------------------------------------------------------------------------
   '
   ' Note that the help file was already optimized. Since a demo string is added to every page the file will become larger and not smaller!
   '
   ' -----------------------------------------------------------------------------------------
   Dim p As TOptimizeParams
   retval = pdf.Optimize(TOptimizeFlags.ofInMemory Or TOptimizeFlags.ofNewLinkNames Or TOptimizeFlags.ofDeleteInvPaths, p)

   ' No fatal error occurred?
   If pdf.HaveOpenDoc() Then
      If Not pdf.OpenOutputFile(OutFile) Then
         Call pdf.FreePDF
         Exit Function
      End If
      ConvertFile = pdf.CloseFile()
   End If
End Function

Private Sub Command1_Click()
   Dim OutFile As String
   OutFile = App.Path & "\out.pdf"
   If ConvertFile("../../../dynapdf_help.pdf", OutFile) Then
      ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   ' Set the license key here if you have one
   ' Call pdf.SetLicenseKey("")

   ' Non embedded CID fonts depend usually on the availability of external cmaps.
   ' External cmaps should be loaded if possible.
   Call pdf.SetCMapDir(GetFullPath("../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
